import xml.etree.ElementTree as ET

class Config():

	currentConfig = "data/config.xml"

	def __init__(self):
		self.lines = ''
		self.readConfigFile(self.currentConfig)
		self.stand = None
		self.wifi = None


	def readConfigFile(self, filename):
		try:
			tree = ET.parse(filename)
			tree = tree.getroot()
			print(tree)
		except:
			tree = None

		self.tree = tree

	def _getDict(self, s):
		d = {}

		try:
			list = self.tree.find(s)
			if list is None:
				return None

			for child in list:
				#print(child.tag.lower())
				if "enable" in child.tag.lower():
					if child.text.lower() in ['true', '1', 't', 'y', 'yes']:
						d[child.tag] = True
					else:
						d[child.tag] = False
				else:
					d[child.tag] = child.text
		except:
			pass

		if len(d) == 0:
			return None

		return d

	def getStand(self):
		return self._getDict('.//stand')

	def getAutoTest(self):
		return self._getDict('.//autotest')

	def getBeep(self):
		return self._getDict('.//beep')

	def getLogo(self):
		return self._getDict('.//logo')

	def getFavorite(self):
		return self._getDict('.//favorite')

	def getWifi(self):
		return self._getDict('.//wifi')

	def getLora(self):
		return self._getDict('.//lora')

	def getLive(self):
		return self._getDict('.//live')

	def getBoot(self):
		return self._getDict('.//boot')

# config = Config()
#
# print(config.getStand()['name'])
# print(config.getStand()['enable'])
# print(config.getWifi()['enable'])
# print(config.getWifi()['ssid'])
# print(config.getWifi()['password'])
# print(config.getLora()['enable'])
